#ifndef FLASHSTART
  #define FLASH SRAM
#endif

#ifndef RAMSTART
  #define RAMSTART 0x20000000
#endif

#ifndef RAMSIZE
  #define RAMSIZE 32K
#endif

#ifndef FLASHSIZE
  #define FLASHSIZE 128K
#endif

#ifndef STACKSIZE
  #define STACKSIZE 0x200
#endif

#ifndef ETRSIZE
  #define ETRSIZE 0x0
#endif

#ifndef ETRALIGN
  #define ETRALIGN 0x100
#endif

MEMORY
{
#ifdef FLASHSTART
    FLASH (rx) : ORIGIN = FLASHSTART, LENGTH = FLASHSIZE
#endif
    SRAM (rwx) : ORIGIN = RAMSTART, LENGTH = RAMSIZE
}

SECTIONS
{
    .isr_vector :
    {
        __isr_base = . ;
        . = ALIGN(0x20);
        KEEP(*(.isr_vector))
    } > FLASH =0x00

    .text :
    {
        . = ALIGN(0x40);
        KEEP(*(.text.crt*))
        *(.text*)
        . = ALIGN(4);
        _etext = .;
    } > FLASH

    .eh_frame_hdr : ALIGN (4)
    {
        KEEP (*(.eh_frame_hdr))
        *(.eh_frame_entry .eh_frame_entry.*)
    } > FLASH
    .eh_frame : ALIGN (4)
    {
        KEEP (*(.eh_frame)) *(.eh_frame.*)
    } > FLASH
    .ARM.exidx : 
    {
        __exidx_start = .;
        KEEP(*(.ARM.exidx*))
        KEEP(*(.gnu.linkonce.armexidx.*))
        __exidx_end = .;
    } > FLASH

    .rodata :
    {
        *(.rodata*)
        *(.constdata*)
        . = ALIGN(4);
#ifdef FLASHSTART
        _sidata = .;
        . += SIZEOF(.data);
        _esidata = .;
#endif
    } > FLASH

#ifdef FLASHSTART
    .data : AT (_sidata)
#else
    .data : 
#endif
    {
        __init_array_start = .;
        __init_array_end = .;
        __data_start = . ;
        __data = .;
        *(vtable*)
        *(.data*)
	. = ALIGN(4);
        __data_end = .;
    } > SRAM

    .bss : ALIGN(6) {
        __bss_start = .;
        * (.sbss*)
        * (.bss*)
        * (COMMON)
        . = ALIGN(4);
        __bss_end = .;
    } > SRAM

    .stack :
    {
        . = ALIGN(0x4);
        __stack_start = .;
        . += STACKSIZE;
        __stack_end = .;
    } > SRAM

    __heap_start = .;
    
    .stack_mp (RAMSTART+RAMSIZE-STACKSIZE-ETRSIZE-((RAMSTART+RAMSIZE)&(ETRALIGN-1))) :
    {
        __stack_start_mp = .;
        . += STACKSIZE;
        __stack_end_mp = .;
    } > SRAM
    
#if ETRSIZE>0x0
    .etr ALIGN(ETRALIGN):
    {
        __etr_start = .;
        . += ETRSIZE;
        __etr_end = .;
    } > SRAM
#endif
}

__SRAM_start = ORIGIN(SRAM);
__SRAM_size  = LENGTH(SRAM);
__data_vaddr = ADDR(.data);
__data_laddr = LOADADDR(.data);
__data_size  = SIZEOF(.data);
__stack_size = SIZEOF(.stack);
