
import lauterbach.trace32.rcl as t32
import tkinter as tk
from tkinter import ttk
from tkinter import PhotoImage
from time import  sleep         
from threading import Thread
import matplotlib.pyplot as plt
import os

#=====================================================
class OOP():
    def __init__(self):         # Initializer method
        self.win = tk.Tk()
        self.logStarted = False
        self.isAccelerated = False
        self.win.title("Car GUI")
        self.create_widgets()
        try:
            self.dbg = t32.connect(protocol="TCP")
        except:
            print ("connection error")
        else:
            self.dbg.cmd('PRINT "Car GUI connected to TRACE32 PowerView"')
            self.btn_logenable.configure(state='enabled')
            self.circle5_id.create_oval(10-6,10-6,10+6,10+6, fill='red')
            self.stop_thread = False
            self.create_thread()

    def drive(self):
        try:
            self.dbg.variable.write_by_name(name='Car.DriveOn',value=1)
        except:
            print ('Starting car failed')

    def method_in_a_thread(self):
        addr = self.dbg.variable.read_by_name(name='Car.Accelerator')
        acc1_previous = self.dbg.variable.read_by_name(name='Car.Accelerator').value
        acc2_previous = acc1_previous
        self.slider.set(acc1_previous)
        while True:
            if self.stop_thread:
                break
            try:
                kmh = self.dbg.variable.read_by_name(name='Car.Kmh').value
                rev = self.dbg.variable.read_by_name(name='Car.EngineRevolutions').value
                gear = self.dbg.variable.read_by_name(name='Car.Gear').value
                brake = self.dbg.variable.read_by_name(name='Car.BrakeOn').value
                addr = self.dbg.variable.read_by_name(name='Car.Accelerator')
                acc1 = self.dbg.variable.read_by_name(name='Car.Accelerator').value
            except:
                print ('Car values not read')
            else:
                try:
                    self.a_label1val.config(text=kmh)
                    self.a_label2val.config(text=rev)
                    self.a_label3val.config(text=gear)
                    self.progress_bar["value"] = kmh
                    self.progress_bar.update()

                    if self.logStarted:
                        self.file_kmh.write(str(kmh)+'\n')
                        self.file_rev.write(str(rev)+'\n')
                        self.file_gear.write(str(gear)+'\n')

                    #update led
                    if gear != 0:
                        self.circle1_id.create_oval(10-6,10-6,10+6,10+6, fill='green')
                    else:
                        self.circle1_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')

                    if brake != 0:
                        self.circle2_id.create_oval(10-6,10-6,10+6,10+6, fill='red')
                    else:
                        self.circle2_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')

                    if kmh == 0:
                        self.circle3_id.create_oval(10-6,10-6,10+6,10+6, fill='red')
                    else:
                        self.circle3_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')

                    #read any new value for accelerator from the slider
                    acc2 = self.slider.get()
                    acc2 = int(acc2)
                    if acc2 != acc2_previous:
                        self.dbg.variable.write_by_name(name='Car.Accelerator',value=acc2)
                        self.slider.set(acc2)
                        acc2_previous = acc2
                    elif acc1 != acc1_previous:
                        self.slider.set(acc1)
                        acc1_previous = acc1

                    if self.isAccelerated:
                        self.isAccelerated = False
                        if (acc2+5)<=95:
                            acc2 = acc2+5
                        else:
                            acc2 = 100
                        self.dbg.variable.write_by_name(name='Car.Accelerator',value=acc2)
                        self.slider.set(acc2)
                        acc2_previous = acc2
                except:
                    pass
                sleep(0.1)

    # Running methods in Threads
    def create_thread(self):
        self.run_thread = Thread(target=self.method_in_a_thread) 
        self.run_thread.setDaemon(True) 
        self.run_thread.start()
                
    # Button callback
    def accelerate(self):
        self.isAccelerated = True

    # Button callback
    def brake(self):
        try:
            self.dbg.variable.write_by_name(name='Car.BrakeOn',value=1)
        except:
            print ('Braking failed')


    # Button callback
    def start_log(self):
        self.logStarted = True
        self.btn_logenable.configure(state='disabled')
        self.btn_logdisable.configure(state='enabled')
        self.circle4_id.create_oval(10-6,10-6,10+6,10+6, fill='green')
        self.circle5_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.btn_logshow.configure(state='disabled')

        self.file_kmh = open('kmh.txt', 'w')
        self.file_rev = open('rev.txt', 'w')
        self.file_gear = open('gear.txt', 'w')

    # Button callback
    def stop_log(self):
        self.logStarted = False
        self.btn_logenable.configure(state='enabled')
        self.btn_logdisable.configure(state='disabled')
        self.circle4_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.circle5_id.create_oval(10-6,10-6,10+6,10+6, fill='red')
        self.btn_logshow.configure(state='enabled')

        self.file_kmh.close()
        self.file_rev.close()
        self.file_gear.close()

    # Button callback
    def show_log(self):
        if self.logStarted:
            self.stop_log()

        lines1, lines2, lines3 = list(), list(), list()
        if os.path.isfile('kmh.txt'):
            with open('kmh.txt', 'r') as f1:
                lines1 = f1.readlines()
                values1 = [float(s) for s in lines1]
                abscissas1 = list(range(len(lines1)))

            plt.figure(1)
            plt.xlabel('Time')
            plt.ylabel('Km/h')
            plt.title('Car Speed')
            plt.plot(abscissas1, values1)
            plt.grid(True)

        if os.path.isfile('rev.txt'):
            with open('rev.txt', 'r') as f2:
                lines2 = f2.readlines()
                values2 = [float(s) for s in lines2]
                abscissas2 = list(range(len(lines2)))

            plt.figure(2)
            plt.xlabel('Time')
            plt.ylabel('Rev/min')
            plt.title('Engine Revolutions')
            plt.plot(abscissas2, values2)
            plt.grid(True)

        if os.path.isfile('gear.txt'):
            with open('gear.txt', 'r') as f3:
                lines3 = f3.readlines()
                values3 = [float(s) for s in lines3]
                abscissas3 = list(range(len(lines3)))

            plt.figure(3)
            plt.xlabel('Time')
            plt.ylabel('Gear')
            plt.title('Gear')
            plt.plot(abscissas3, values3)
            plt.grid(True)

        if lines1 or lines2 or lines3:
            plt.show()

    # Exit GUI cleanly
    def _quit(self):
        try:
            if self.logStarted:
                self.stop_log()
        except:
            pass
        self.win.quit()
        self.win.destroy()
        exit() 
                  
    #####################################################################################       
    def create_widgets(self):
        # LabelFrame using win as the parent
        self.mighty = ttk.LabelFrame(self.win, text=' Cockpit ', width=300, height=100)
        self.mighty.grid(column=0, row=1, padx=4, pady=4, columnspan=3)

        # adding a Label using mighty as the parent instead of win
        self.a_label1 = ttk.Label(self.mighty, text="Km/h:")
        self.a_label1.grid(column=0, row=0, padx=20, sticky='W')

        self.a_label2 = ttk.Label(self.mighty, text="Rpm:")
        self.a_label2.grid(column=0, row=1, padx=20, sticky='W')

        self.a_label3 = ttk.Label(self.mighty, text="Gear:")
        self.a_label3.grid(column=0, row=2, padx=20, sticky='W')

        self.a_label1val = ttk.Label(self.mighty, text='0')
        self.a_label1val.grid(column=1, row=0, padx=10, sticky='W')

        self.a_label2val = ttk.Label(self.mighty, text="0")
        self.a_label2val.grid(column=1, row=1, padx=10, sticky='W')

        self.a_label3val = ttk.Label(self.mighty, text="0")
        self.a_label3val.grid(column=1, row=2, padx=10, sticky='W')

        self.separ = ttk.Separator(self.mighty, orient="vertical")
        self.separ.grid(column=2, row=0, padx=20, rowspan=3, sticky="ns")

        self.a_label4 = ttk.Label(self.mighty, text="Driving:")
        self.a_label4.grid(column=3, row=0, padx=10, sticky='W')

        self.a_label5 = ttk.Label(self.mighty, text="Braking:")
        self.a_label5.grid(column=3, row=1, padx=10, sticky='W')

        self.a_label6 = ttk.Label(self.mighty, text="Stopped:")
        self.a_label6.grid(column=3, row=2, padx=10, sticky='W')

        self.circle1_id = tk.Canvas(self.mighty, width=20, height=20)
        # canvas.create_oval(x-r,y-r,x+r,y+r)
        self.circle1_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.circle1_id.grid(column=4, row=0)

        self.circle2_id = tk.Canvas(self.mighty, width=20, height=20)
        self.circle2_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.circle2_id.grid(column=4, row=1)

        self.circle3_id = tk.Canvas(self.mighty, width=20, height=20)
        self.circle3_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.circle3_id.grid(column=4, row=2)

        # LabelFrame for Button 1
        self.mighty1 = ttk.LabelFrame(self.win, text=' Accelerator ', width=100, height=100)
        self.mighty1.grid(column=0, row=2, padx=4, pady=4)

        # Adding a Button
        self.photo1 = PhotoImage(file = "triangleUp.png")
        self.action1 = ttk.Button(self.mighty1, image=self.photo1, command=self.accelerate)
        self.action1.grid(column=0, row=0)

        # LabelFrame for Button 2
        self.mighty2 = ttk.LabelFrame(self.win, text=' Brakes ', width=100, height=100)
        self.mighty2.grid(column=1, row=2, padx=4, pady=4)

        # Adding a Button
        self.photo2 = PhotoImage(file = "triangleDown.png")
        self.action2 = ttk.Button(self.mighty2, image=self.photo2, command=self.brake)
        self.action2.grid(column=0, row=0)

        # LabelFrame for Button 3
        self.mighty3 = ttk.LabelFrame(self.win, text=' Start ', width=100, height=100)
        self.mighty3.grid(column=2, row=2, padx=4, pady=4)

        # Adding a Button
        self.photo3 = PhotoImage(file = "triangleRight.png")
        self.action3 = ttk.Button(self.mighty3, image=self.photo3, command=self.drive)   
        self.action3.grid(column=0, row=0)

        # Adding a Label
        self.label1 = ttk.Label(self.win, text="Accelerator:")
        self.label1.grid(column=0, row=3)

        # Adding a Slider
        self.slider = ttk.Scale(self.win, from_=0, to=100)
        self.slider.grid(column=1, row=3, columnspan=2)

        # Adding a Label
        self.label2 = ttk.Label(self.win, text="Km/h:")
        self.label2.grid(column=0, row=4)

        # Add a Progressbar
        self.progress_bar = ttk.Progressbar(self.win, orient='horizontal', length=140, mode='determinate')
        self.progress_bar.grid(column=1, row=4, columnspan=2, pady=10)
        self.progress_bar["maximum"] = 132
 
        # LabelFrame using win as the parent
        self.mighty4 = ttk.LabelFrame(self.win, text=' Log ', width=300, height=100)
        self.mighty4.grid(column=0, row=5, padx=4, pady=4, columnspan=3)

        # Buttons to log data
        self.btn_logenable = ttk.Button(self.mighty4, text=' Start Log ', command=self.start_log)
        self.btn_logenable.grid(column=0, row=5, padx=10, pady=10)
        self.btn_logenable.configure(state='disabled')

        self.btn_logdisable = ttk.Button(self.mighty4, text= ' Stop Log ', command=self.stop_log)
        self.btn_logdisable.grid(column=2, row=5, padx=10, pady=10)
        self.btn_logdisable.configure(state='disabled')

        self.circle4_id = tk.Canvas(self.mighty4, width=20, height=20)
        self.circle4_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.circle4_id.grid(column=1, row=5)

        self.circle5_id = tk.Canvas(self.mighty4, width=20, height=20)
        self.circle5_id.create_oval(10-6,10-6,10+6,10+6, fill='#DCDCDC')
        self.circle5_id.grid(column=3, row=5)

        self.btn_logshow = ttk.Button(self.mighty4, text=' Show Log ', command=self.show_log)
        self.btn_logshow.grid(column=2, row=6, padx=10, pady=10)

        # Change the main windows icon
        self.win.iconbitmap('trace32.ico')
  
                 
#======================
# Start GUI
#======================
oop = OOP()
t32.init(t32sys='c:\\t32')
oop.win.mainloop()
