#include "car.h"
struct CarModel Car;

const float PiGreek = 3.14;

void IncreaseGear (unsigned int g);
void DecreaseGear (unsigned int g);
int RevolutionsToDownshift (int g);
int RevolutionsToUpshift (int g);
double Ratio (int g);


// Init car data
void CarDemoInit(void)
{
Car.RevolutionsMin=900;
Car.RevolutionsToDownshift[0]=1000;
Car.RevolutionsToDownshift[1]=1200;
Car.RevolutionsToDownshift[2]=1200;
Car.RevolutionsToDownshift[3]=2000;
Car.RevolutionsToDownshift[4]=2000;
Car.RevolutionsToUpshift[0]=6000;
Car.RevolutionsToUpshift[1]=3500;
Car.RevolutionsToUpshift[2]=3500;
Car.RevolutionsToUpshift[3]=3500;
Car.RevolutionsToUpshift[4]=6500;
Car.Ratio[0]=0.000001;
Car.Ratio[1]=0.04;
Car.Ratio[2]=0.08;
Car.Ratio[3]=0.12;
Car.Ratio[4]=0.18;
Car.GearMin=0;
Car.GearMax=4;

Car.Wheel = 1.88;
Car.EngineRevolutions = 900;
Car.EngineRevolutions10 = Car.EngineRevolutions/10;
Car.Gear = 0;
Car.GearMin = 0;
Car.Accelerator = 0;
Car.Steering = 128;
Car.Temperature = 90;
Car.DriveOn = 0;
Car.BrakeOn = 0;
Car.Mass = 1000;
Car.MaxTorque = 800;
Car.MinTorque = 80;
Car.coefficientR = 0.000087;
Car.coefficientM = 2.4;
Car.coefficientB = 5.0;
Car.BrakingTorque = 0;

// Compute initial values
Car.RevolutionsWheel = 0;  // because Car.Gear = 0;
Car.Speed = Car.RevolutionsWheel * Car.Wheel /60;
Car.AngularSpeed = Car.EngineRevolutions * (2*PiGreek) / 60;
Car.MomentInertia  = Car.coefficientM * Car.Mass;
}

// Compute speed
void CarDemoCalc(void)
{
// Gear 0 --> 1 = going to start the car
if ((Car.DriveOn == 1) && (Car.Gear == Car.GearMin))
    IncreaseGear(Car.Gear);

if (Car.Accelerator<=0)
    Car.Accelerator = 0;   // 0%
if (Car.Accelerator>=100)
    Car.Accelerator = 100; // 100%

if (Car.BrakeOn) {
    Car.Accelerator = 0;
    Car.BrakingTorque = Car.coefficientB * Car.Mass * 9.8 / Car.AngularSpeed;
} else
    Car.BrakingTorque = 0;

// Calculate the torques and the engine's expected revolutions
Car.DrivingTorque = (Car.MaxTorque * Car.Accelerator / 100) + Car.MinTorque;
Car.ResistantTorque = ((Car.coefficientR*Car.AngularSpeed) * Car.Mass * 9.8) + Car.BrakingTorque;    // Newton * m = (k)*(m)*(g) + Braking Torque if any
Car.DeltaAngularSpeed = (double) (Car.DrivingTorque - Car.ResistantTorque) / Car.MomentInertia;
Car.ExpectedRevolutions = (Car.AngularSpeed + Car.DeltaAngularSpeed) * 60 / (2*PiGreek);

// Limit the engine revolutions on lower and higher gears
if ((Car.Gear==Car.GearMin) || (Car.Gear==Car.GearMax)) {
    if (Car.ExpectedRevolutions <= RevolutionsToUpshift(Car.Gear)) {
      Car.AngularSpeed += Car.DeltaAngularSpeed;
      Car.EngineRevolutions = Car.AngularSpeed * 60 / (2*PiGreek);
    }
}
else {
    Car.AngularSpeed += Car.DeltaAngularSpeed;
    Car.EngineRevolutions = Car.AngularSpeed * 60 / (2*PiGreek);
}

// Check Engine Revolutions limits
if ((Car.EngineRevolutions>=RevolutionsToUpshift(Car.Gear)) && (Car.Gear<Car.GearMax) && (Car.Gear!=Car.GearMin)) {
    IncreaseGear(Car.Gear);                 // change Gear++
}
if ((Car.EngineRevolutions<=RevolutionsToDownshift(Car.Gear)) && (Car.Gear>(Car.GearMin+1)))  {
    DecreaseGear(Car.Gear);                 // change Gear--
}
// Gear 1 --> 0 = going to stop the car
if ((Car.Gear==(Car.GearMin+1)) && Car.BrakeOn)
    DecreaseGear(Car.Gear);

if ((Car.GearPrev!=Car.Gear) && (Car.Gear!=Car.GearMin) && (Car.Gear!=Car.GearMin+1))  {
     // Gear is changed: change Engine Revolutions based on previous speed
    Car.EngineRevolutions = Car.RevolutionsWheel / Ratio(Car.Gear);
    Car.AngularSpeed = Car.EngineRevolutions * (2*PiGreek) / 60;
}

// Stop the car
if ((Car.EngineRevolutions <= Car.RevolutionsMin) && (Car.BrakeOn != 0))
{
    Car.BrakeOn = 0;
    Car.DriveOn = 0;
}

Car.GearPrev=Car.Gear;
Car.RevolutionsWheel = Car.EngineRevolutions * Ratio(Car.Gear);
if ((Car.Gear!=Car.GearMin) || (Car.BrakeOn!=0))
    Car.Speed = Car.RevolutionsWheel * Car.Wheel /60;
Car.Kmh = Car.Speed * 3600 / 1000;
Car.EngineRevolutions10 = Car.EngineRevolutions / 10;
}

void IncreaseGear (unsigned int g)
{
  switch (g)
  {
    case 0:
      Car.Gear = 1;
      break;
    case 1:
      Car.Gear = 2;
      break;
    case 2:
      Car.Gear = 3;
      break;
    case 3:
      Car.Gear = 4;
      break;
  }
}

void DecreaseGear (unsigned int g)
{
  switch (g)
  {
    case 1:
      Car.Gear = 0;
      break;
    case 2:
      Car.Gear = 1;
      break;
    case 3:
      Car.Gear = 2;
      break;
    case 4:
      Car.Gear = 3;
      break;
  }
}

int RevolutionsToDownshift (int g)
{
  int rev = 0;

  switch (g)
  {
    case 0:
      rev = Car.RevolutionsToDownshift[0];
      break;
    case 1:
      rev = Car.RevolutionsToDownshift[1];
      break;
    case 2:
      rev = Car.RevolutionsToDownshift[2];
      break;
    case 3:
      rev = Car.RevolutionsToDownshift[3];
      break;
    case 4:
      rev = Car.RevolutionsToDownshift[4];
      break;
  }

  return (rev);
}

int RevolutionsToUpshift (int g)
{
  int rev = 0;

  switch (g)
  {
    case 0:
      rev = Car.RevolutionsToUpshift[0];
      break;
    case 1:
      rev = Car.RevolutionsToUpshift[1];
      break;
    case 2:
      rev = Car.RevolutionsToUpshift[2];
      break;
    case 3:
      rev = Car.RevolutionsToUpshift[3];
      break;
    case 4:
      rev = Car.RevolutionsToUpshift[4];
      break;
  }

  return (rev);
}

double Ratio (int g)
{
  double val = 1;

  switch (g)
  {
    case 0:
      val = Car.Ratio[0];
      break;
    case 1:
      val = Car.Ratio[1];
      break;
    case 2:
      val = Car.Ratio[2];
      break;
    case 3:
      val = Car.Ratio[3];
      break;
    case 4:
      val = Car.Ratio[4];
      break;
  }

  return (val);
}
