#include "FreeRTOS.h"
#include "task.h"
#include "stm32_gpio.h"
#include "logger.h"


#define PRESS_TIMEOUT_MS 500
#define LONG_PRESS_MS 2000 

#define TRUE 1
#define FALSE 0
#define SIZE 18

TaskHandle_t task1;
TaskHandle_t task2;
TaskHandle_t task3;
TaskHandle_t controller;
uint8_t pressCount = 0;


/*-----------------------------------------------------------*/

static int mstatic1, mstatic2, mcount;
const char cstr1[] = "Constant String1";

char vdblarray[5][6];
char vtriplearray[2][3][4];

static short sinewave[630];

TickType_t nCurrentTick;

typedef struct struct1 {
	char * word;
	int count;
	struct struct1 * left;
	struct struct1 * right;
	int field1:2;
	unsigned field2:3;
} strtype1 ;

strtype1 ast;

struct abc
{
	int x;
	int y;
};

struct abc def;

static void func1( intptr )		/* static function */
int * intptr;
{
	T32_LoggerData (T32_FETCH, (void*)(((uint32_t)func1) & ~1U), 0 /* unused */);
	(*intptr)++;
	T32_LoggerData (T32_FETCH, NULL, 0 /* unused */);
}

void func2()
{
	int autovar;
	register int regvar;
	static int fstatic = 44;	/* initialized static variable */
	static int fstatic2;		/* not initialized static variable */
	
	T32_LoggerData (T32_FETCH, (void*)(((uint32_t)func2) & ~1U), 0 /* unused */);
	
	autovar = regvar = fstatic;
	autovar++;

	func1( &autovar );	/* to force autovar as stack-scope */

	func1( &fstatic );	/* to force fstatic as static-scope */

	for ( regvar = 0; regvar < 5 ; regvar++ )
		mstatic1 += regvar*autovar;

	fstatic += mstatic1;

	fstatic2 = 2*fstatic;

	func1( &fstatic2 );
	T32_LoggerData (T32_FETCH, NULL, 0 /* unused */);
}

static int * func9()			/* nested local variables */
{
	static int stat1 = 0;
	register int reg1;
	auto int auto1;
	T32_LoggerData (T32_FETCH, (void*)(((uint32_t)func9) & ~1U), 0 /* unused */);
	auto1 = stat1;

	for ( reg1 = 0 ; reg1 < 2 ; reg1++ )
	{
		static int stat2 = 0;
		register int reg2;
		auto int auto2;

		auto2 = stat2;

		for ( reg2 = 0 ; reg2 < reg1 ; reg2++ )
		{
			func1( &stat1 );
			func1( &auto1 );
			func1( &stat2 );
			func1( &auto2 );
		}
	}
	T32_LoggerData (T32_FETCH, NULL, 0 /* unused */);
	return &stat1;
}

int int_sin(unsigned int x)
{
	int sign=1;
	if (x&0x20)
		sign=-1;
	x=x&0x1f;
	if ((x&0x10)&&(x&0xf))
		x=0x10-(x&0xf);
	
	// sin(x) -Pi/2 <= x <= Pi/2 = x-x^3/3!+x^5/5!-...
	return sign*((120*10*10*10*10*x - (20*10*10*x*x*x) + (x*x*x*x*x))>>9);
}

static void func_sin()
{
	int x;
	T32_LoggerData (T32_FETCH, (void*)(((uint32_t)func_sin) & ~1U), 0 /* unused */);
	for (x = 0; x < 628; x++)
		sinewave[x] = int_sin(x)/(x/32+1);
	T32_LoggerData (T32_FETCH, NULL, 0 /* unused */);
}

int func13( a, c, e )			/* arguments and locals stack-tracking */
int a, c, e;
{
	int b, d, f;
	T32_LoggerData (T32_FETCH, (void*)(((uint32_t)func13) & ~1U), 0 /* unused */);
	b = a+c+e;
	f = b+a;
	d = f*b;

	if ( e > 0 )
		c += func13( b, f, e-1 );
	T32_LoggerData (T32_FETCH, NULL, 0 /* unused */);
	return c+e+d;
}

int sieve();


static void gpio_init(void)
{
    RCC_AHB2ENR |= GPIOBEN;
    RCC_AHB2ENR |= GPIOCEN;
    RCC_AHB2ENR |= GPIOFEN;
    RCC_AHB2ENR |= GPIOGEN;

    GPIOB_MODE_R &= ~(3U << (2 * LED_GREEN));
    GPIOB_MODE_R |= (1U << (2 * LED_GREEN));

    GPIOF_MODE_R &= ~(3U << (2 * LED_YELLOW));
    GPIOF_MODE_R |= (1U << (2 * LED_YELLOW));

    GPIOG_MODE_R &= ~(3U << (2 * LED_RED));
    GPIOG_MODE_R |= (1U << (2 * LED_RED));

    GPIOC_MODE_R &= ~(3U << (2 * BUTTON_PIN));
    GPIOC_PUPDR |= (2U << (2 * BUTTON_PIN));  
}


static void Task1_func(void *pvParameters)
{
    for (;;) {
		vTaskSuspend(NULL); 
		
        GPIOB_OD_R |= (1U << LED_GREEN);
        for (volatile int i = 0; i < 500000; ++i);
        GPIOB_OD_R &= ~(1U << LED_GREEN);
		
		func_sin();
		
		mstatic1 = 12;
		mstatic2 = 34;
		mcount++;

		vtriplearray[0][0][0] = 1;
		vtriplearray[1][0][0] = 2;
		vtriplearray[0][1][0] = 3;
		vtriplearray[0][0][1] = 4;

		func2();

		func9();

		func13( 1, 2, 3 );
		
		sieve();
    }
}

char flags[SIZE+1];

int sieve()				/* sieve of erathostenes */
{
	register int i, primz, k;
	int anzahl;
	T32_LoggerData (T32_FETCH, (void*)(((uint32_t)sieve) & ~1U), 0 /* unused */);
	anzahl = 0;

	for ( i = 0 ; i <= SIZE ; flags[ i++ ] = TRUE ) ;

	for ( i = 0 ; i <= SIZE ; i++ )
	{
		if ( flags[ i ] )
		{
			primz = i + i + 3;
			k = i + primz;
			while ( k <= SIZE )
			{
				flags[ k ] = FALSE;
				k += primz;
			}
			anzahl++;
		}
	}
	T32_LoggerData (T32_FETCH, NULL, 0 /* unused */);
	return anzahl;
}

static void Task2_func(void *pvParameters)
{
    for (;;) { 
		vTaskSuspend(NULL);
		GPIOF_OD_R |= (1U << LED_YELLOW);
        for (volatile int i = 0; i < 500000; ++i);
        GPIOF_OD_R &= ~(1U << LED_YELLOW);
    }
}

static void Task3_func(void *pvParameters)
{	
    for (;;) {
		vTaskSuspend(NULL);
        GPIOG_OD_R |= (1U << LED_RED);
        for (volatile int i = 0; i < 500000; ++i);
        GPIOG_OD_R &= ~(1U << LED_RED);
    }
}



static void Controller_func(void *pvParameters)
{
    static uint8_t lastButtonState = 1;  // Previous state (1 = not pressed, active low)
    for (;;) {
        uint8_t currentButtonState = (GPIOC_IDR & (1U << BUTTON_PIN)) == 0; // Active low
        // Button press detected (falling edge)
        if (lastButtonState == 1 && currentButtonState == 0) {
            vTaskSuspend(NULL);  // Go idle on button press
        } else {
            // No button press detected: run all tasks
            vTaskResume(task1);
            vTaskResume(task2);
            vTaskResume(task3);
        }

        lastButtonState = currentButtonState;

        // Short busy-wait delay
        for (volatile int i = 0; i < 50000; ++i);
    }
}


void vCreateMidiDemo()
{
		gpio_init();
		T32_LoggerInit();

		xTaskCreate(Controller_func, "Controller_Task", configMINIMAL_STACK_SIZE, NULL, 1, &controller);
		xTaskCreate(Task1_func, "Task_1", configMINIMAL_STACK_SIZE, NULL, 2 , &task1);
		xTaskCreate(Task2_func, "Task_2", configMINIMAL_STACK_SIZE, NULL, 2, &task2);
		xTaskCreate(Task3_func, "Task_3", configMINIMAL_STACK_SIZE, NULL, 2, &task3);

		vTaskSuspend(task1);
		vTaskSuspend(task2);
		vTaskSuspend(task3);
		vTaskResume(controller);

		vTaskStartScheduler();
}
